# 第9课：for循环

## 学习目标
- 掌握 for 循环的使用
- 学会使用 range() 函数
- 理解遍历的概念

## 课程内容

### for 循环基础
for 循环用于遍历序列（如列表、字符串、范围等）。

```python
# 遍历字符串
for char in "Python":
    print(char)

# 输出：
# P
# y
# t
# h
# o
# n
```

### range() 函数

#### range(结束值)
```python
# 从0开始，到4结束（不包括5）
for i in range(5):
    print(i)

# 输出：0 1 2 3 4
```

#### range(开始值, 结束值)
```python
# 从1开始，到5结束（不包括6）
for i in range(1, 6):
    print(i)

# 输出：1 2 3 4 5
```

#### range(开始值, 结束值, 步长)
```python
# 从0开始，每次增加2
for i in range(0, 10, 2):
    print(i)

# 输出：0 2 4 6 8

# 倒序
for i in range(10, 0, -1):
    print(i)

# 输出：10 9 8 7 6 5 4 3 2 1
```

### 常用示例

#### 示例1：打印乘法表
```python
number = int(input("请输入数字(1-9)："))

for i in range(1, 10):
    result = number * i
    print(f"{number} × {i} = {result}")
```

#### 示例2：求和
```python
# 计算1到100的和
total = 0

for i in range(1, 101):
    total += i

print(f"1到100的和：{total}")  # 5050
```

#### 示例3：遍历字符串
```python
name = "Python"

# 方法1：直接遍历
for char in name:
    print(char)

# 方法2：使用索引
for i in range(len(name)):
    print(f"索引{i}：{name[i]}")
```

### 嵌套循环
循环里面还可以有循环：

```python
# 打印矩形
for i in range(3):  # 3行
    for j in range(5):  # 5列
        print("*", end="")
    print()  # 换行

# 输出：
# *****
# *****
# *****
```

#### 九九乘法表
```python
print("九九乘法表：")
for i in range(1, 10):
    for j in range(1, i + 1):
        print(f"{j}×{i}={i*j}", end="\t")
    print()  # 换行
```

### 遍历列表
```python
fruits = ["苹果", "香蕉", "橙子", "葡萄"]

# 方法1：直接遍历
for fruit in fruits:
    print(fruit)

# 方法2：使用索引
for i in range(len(fruits)):
    print(f"{i+1}. {fruits[i]}")

# 输出：
# 1. 苹果
# 2. 香蕉
# 3. 橙子
# 4. 葡萄
```

### 实用应用

#### 示例1：统计字符
```python
text = input("请输入一段文字：")
vowel_count = 0  # 元音计数

for char in text.lower():
    if char in "aeiou":
        vowel_count += 1

print(f"元音字母个数：{vowel_count}")
```

#### 示例2：找最大值
```python
numbers = [23, 45, 12, 67, 34, 89, 15]
max_num = numbers[0]

for num in numbers:
    if num > max_num:
        max_num = num

print(f"最大值：{max_num}")
```

#### 示例3：倒计时
```python
print("倒计时开始！")
for i in range(5, 0, -1):
    print(i)
print("发射！🚀")
```

### for vs while
什么时候用哪个？

```python
# 知道循环次数 → 用 for
for i in range(10):
    print(i)

# 不知道循环次数 → 用 while
password = "123456"
user_input = ""
while user_input != password:
    user_input = input("请输入密码：")
```

## 练习题

### 练习1：求平均分
输入5个学生的成绩，计算平均分。

### 练习2：打印图案
使用嵌套循环打印以下图案：
```
*
**
***
****
*****
```

### 练习3：找出所有偶数
给定一个数字列表，找出并打印所有的偶数。
列表：[12, 7, 23, 18, 9, 34, 15, 28]

### 练习4：字符统计
输入一个字符串，统计其中数字、字母和其他字符的个数。

### 参考答案
```python
# 练习1：求平均分
print("=== 求平均分 ===")
total = 0

for i in range(1, 6):
    score = float(input(f"请输入第{i}个学生的成绩："))
    total += score

average = total / 5
print(f"平均分：{average:.2f}")

# 练习2：打印图案
print("\n=== 打印图案 ===")
for i in range(1, 6):
    for j in range(i):
        print("*", end="")
    print()

# 练习3：找出所有偶数
print("\n=== 找出所有偶数 ===")
numbers = [12, 7, 23, 18, 9, 34, 15, 28]
print("原列表：", numbers)
print("偶数：", end="")

for num in numbers:
    if num % 2 == 0:
        print(num, end=" ")
print()

# 练习4：字符统计
print("\n=== 字符统计 ===")
text = input("请输入一个字符串：")

digit_count = 0    # 数字
letter_count = 0   # 字母
other_count = 0    # 其他

for char in text:
    if char.isdigit():
        digit_count += 1
    elif char.isalpha():
        letter_count += 1
    else:
        other_count += 1

print(f"数字个数：{digit_count}")
print(f"字母个数：{letter_count}")
print(f"其他字符：{other_count}")
```

## 小结
- `for` 循环用于遍历序列
- `range()` 函数生成数字序列
- `range(n)` 从0到n-1
- `range(start, end)` 从start到end-1
- `range(start, end, step)` 可以指定步长
- 嵌套循环可以处理多维问题
- 知道循环次数用 for，不知道用 while

---
**上一课**: [第8课 - while循环](./第8课_while循环.md)  
**下一课**: [第10课 - break和continue](./第10课_break和continue.md)
