# 第8课：while循环

## 学习目标
- 理解循环的概念
- 掌握 while 循环的使用
- 学会控制循环的执行

## 课程内容

### 什么是循环？
循环可以让代码重复执行多次，避免写重复的代码。

### while 循环基础

```python
# 打印1到5
count = 1
while count <= 5:
    print(count)
    count += 1

# 输出：
# 1
# 2
# 3
# 4
# 5
```

**语法结构**：
```python
while 条件:
    # 条件为真时执行的代码
    # 记得更新条件，否则会无限循环
```

### 倒计时示例

```python
print("倒计时开始！")
count = 5

while count > 0:
    print(count)
    count -= 1

print("时间到！")
```

### 累加求和

```python
# 计算1到100的和
total = 0
number = 1

while number <= 100:
    total += number
    number += 1

print(f"1到100的和是：{total}")  # 5050
```

### 用户输入控制循环

```python
# 猜数字游戏
secret_number = 7
guess = 0

while guess != secret_number:
    guess = int(input("请猜一个1-10的数字："))
    
    if guess < secret_number:
        print("太小了！")
    elif guess > secret_number:
        print("太大了！")
    else:
        print("恭喜你猜对了！")
```

### 计数器应用

```python
# 统计输入的数字个数
count = 0
total = 0

print("输入数字进行累加，输入0结束")

number = int(input("请输入数字："))
while number != 0:
    total += number
    count += 1
    number = int(input("请输入数字："))

if count > 0:
    average = total / count
    print(f"共输入{count}个数字")
    print(f"总和：{total}")
    print(f"平均值：{average:.2f}")
```

### 无限循环（需要谨慎使用）

```python
# 简单的菜单系统
while True:
    print("\n=== 菜单 ===")
    print("1. 选项1")
    print("2. 选项2")
    print("3. 退出")
    
    choice = input("请选择：")
    
    if choice == "1":
        print("你选择了选项1")
    elif choice == "2":
        print("你选择了选项2")
    elif choice == "3":
        print("再见！")
        break  # 退出循环
    else:
        print("无效选择")
```

### 实用示例

#### 示例1：密码验证（限制次数）
```python
password = "123456"
attempts = 3

while attempts > 0:
    user_input = input(f"请输入密码（剩余{attempts}次机会）：")
    
    if user_input == password:
        print("密码正确！")
        break
    else:
        attempts -= 1
        if attempts > 0:
            print("密码错误！")
        else:
            print("密码错误！账户已锁定")
```

#### 示例2：存钱计划
```python
target = 10000  # 目标金额
current = 0     # 当前金额
month = 0       # 月数
monthly_save = 500  # 每月存款

print(f"目标：存够{target}元")

while current < target:
    month += 1
    current += monthly_save
    print(f"第{month}个月：已存{current}元")

print(f"需要{month}个月才能存够{target}元")
```

#### 示例3：乘法口诀表（单行）
```python
number = int(input("请输入要背诵的数字(1-9)："))
i = 1

while i <= 9:
    result = number * i
    print(f"{number} × {i} = {result}")
    i += 1
```

## 练习题

### 练习1：求阶乘
输入一个正整数n，计算n的阶乘（n! = 1×2×3×...×n）。
例如：5! = 1×2×3×4×5 = 120

### 练习2：数字反转
输入一个整数，输出它的反转。
例如：输入123，输出321

### 练习3：简单ATM系统
模拟ATM机，初始余额1000元：
- 选项1：查询余额
- 选项2：存款
- 选项3：取款
- 选项4：退出

### 参考答案
```python
# 练习1：求阶乘
print("=== 阶乘计算 ===")
n = int(input("请输入一个正整数："))
factorial = 1
i = 1

while i <= n:
    factorial *= i
    i += 1

print(f"{n}! = {factorial}")

# 练习2：数字反转
print("\n=== 数字反转 ===")
number = int(input("请输入一个整数："))
reversed_num = 0
temp = abs(number)  # 使用绝对值处理

while temp > 0:
    digit = temp % 10  # 获取最后一位
    reversed_num = reversed_num * 10 + digit
    temp = temp // 10  # 去掉最后一位

# 如果原数是负数，结果也是负数
if number < 0:
    reversed_num = -reversed_num

print(f"反转后：{reversed_num}")

# 练习3：简单ATM系统
print("\n=== ATM系统 ===")
balance = 1000

while True:
    print("\n" + "=" * 30)
    print("1. 查询余额")
    print("2. 存款")
    print("3. 取款")
    print("4. 退出")
    print("=" * 30)
    
    choice = input("请选择操作：")
    
    if choice == "1":
        print(f"当前余额：{balance}元")
    
    elif choice == "2":
        amount = float(input("请输入存款金额："))
        if amount > 0:
            balance += amount
            print(f"存款成功！当前余额：{balance}元")
        else:
            print("金额无效！")
    
    elif choice == "3":
        amount = float(input("请输入取款金额："))
        if amount > 0:
            if amount <= balance:
                balance -= amount
                print(f"取款成功！当前余额：{balance}元")
            else:
                print("余额不足！")
        else:
            print("金额无效！")
    
    elif choice == "4":
        print("感谢使用，再见！")
        break
    
    else:
        print("无效选择，请重新输入！")
```

## 小结
- `while` 循环在条件为真时重复执行代码
- 必须确保循环条件最终会变为假，否则会无限循环
- 可以使用 `break` 退出循环
- 常用于次数不确定的重复操作
- 记得在循环中更新控制变量

---
**上一课**: [第7课 - 比较和逻辑运算符](./第7课_比较和逻辑运算符.md)  
**下一课**: [第9课 - for循环](./第9课_for循环.md)
