# 第7课：比较和逻辑运算符

## 学习目标
- 掌握比较运算符的使用
- 学会使用逻辑运算符
- 理解复合条件判断

## 课程内容

### 比较运算符
比较运算符用于比较两个值，返回 True 或 False。

```python
# 等于 ==
print(5 == 5)   # True
print(5 == 3)   # False

# 不等于 !=
print(5 != 3)   # True
print(5 != 5)   # False

# 大于 >
print(5 > 3)    # True
print(3 > 5)    # False

# 小于 <
print(3 < 5)    # True
print(5 < 3)    # False

# 大于等于 >=
print(5 >= 5)   # True
print(5 >= 3)   # True

# 小于等于 <=
print(3 <= 5)   # True
print(5 <= 5)   # True
```

### 逻辑运算符

#### and（与）- 所有条件都为真
```python
age = 20
has_id = True

# 两个条件都要满足
if age >= 18 and has_id:
    print("可以进入")

# 示例
print(True and True)    # True
print(True and False)   # False
print(False and False)  # False
```

#### or（或）- 至少一个条件为真
```python
is_weekend = True
is_holiday = False

# 只要有一个条件满足
if is_weekend or is_holiday:
    print("可以休息")

# 示例
print(True or False)    # True
print(False or False)   # False
print(True or True)     # True
```

#### not（非）- 取反
```python
is_raining = False

# 取反操作
if not is_raining:
    print("不下雨，可以出门")

# 示例
print(not True)   # False
print(not False)  # True
```

### 复合条件判断

#### 示例1：年龄和身高限制
```python
age = int(input("请输入年龄："))
height = int(input("请输入身高(cm)："))

if age >= 12 and height >= 140:
    print("可以乘坐过山车")
else:
    print("不符合乘坐条件")
```

#### 示例2：会员折扣
```python
is_member = input("是否是会员？(是/否)：") == "是"
amount = float(input("购买金额："))

if is_member or amount >= 500:
    discount = 0.9  # 9折
    print(f"享受折扣！实付：{amount * discount}元")
else:
    print(f"无折扣，实付：{amount}元")
```

#### 示例3：成绩判断
```python
chinese = int(input("语文成绩："))
math = int(input("数学成绩："))
english = int(input("英语成绩："))

# 所有科目都及格
if chinese >= 60 and math >= 60 and english >= 60:
    print("全部及格！")
else:
    print("有科目不及格")

# 至少有一科优秀
if chinese >= 90 or math >= 90 or english >= 90:
    print("至少有一科优秀！")
```

### 运算符优先级
从高到低：
1. `not`
2. `and`
3. `or`

```python
# 使用括号明确优先级
result = (True or False) and True
print(result)  # True

# not 优先级最高
result = not False and True
print(result)  # True (相当于 (not False) and True)
```

### 实用技巧

#### 链式比较
```python
age = 25

# 传统写法
if age >= 18 and age <= 60:
    print("工作年龄段")

# 链式比较（更简洁）
if 18 <= age <= 60:
    print("工作年龄段")
```

#### 成员运算符
```python
# in 运算符
fruit = "苹果"
if fruit in ["苹果", "香蕉", "橙子"]:
    print("这是水果")

# not in 运算符
day = "星期一"
if day not in ["星期六", "星期日"]:
    print("工作日")
```

## 练习题

### 练习1：登录验证增强版
编写登录系统，要求：
- 用户名正确 AND 密码正确：登录成功
- 否则：登录失败

### 练习2：奖学金评定
评定标准：
- 平均分 >= 90 AND 无挂科：一等奖学金
- 平均分 >= 80 AND 无挂科：二等奖学金
- 平均分 >= 70 AND 无挂科：三等奖学金
- 其他：无奖学金

### 练习3：购票系统
电影票价格规则：
- 学生 OR 老人(>=60岁)：半价
- 会员：8折
- 学生会员 OR 老人会员：5折
- 普通票：全价

基础票价50元，计算实际票价。

### 参考答案
```python
# 练习1：登录验证增强版
print("=== 登录系统 ===")
username = input("请输入用户名：")
password = input("请输入密码：")

if username == "admin" and password == "123456":
    print("登录成功！")
else:
    print("用户名或密码错误！")

# 练习2：奖学金评定
print("\n=== 奖学金评定 ===")
score1 = float(input("科目1成绩："))
score2 = float(input("科目2成绩："))
score3 = float(input("科目3成绩："))

average = (score1 + score2 + score3) / 3
no_fail = score1 >= 60 and score2 >= 60 and score3 >= 60

print(f"平均分：{average:.2f}")

if average >= 90 and no_fail:
    print("恭喜获得一等奖学金！")
elif average >= 80 and no_fail:
    print("恭喜获得二等奖学金！")
elif average >= 70 and no_fail:
    print("恭喜获得三等奖学金！")
else:
    print("未获得奖学金")

# 练习3：购票系统
print("\n=== 购票系统 ===")
age = int(input("请输入年龄："))
is_student = input("是否是学生？(是/否)：") == "是"
is_member = input("是否是会员？(是/否)：") == "是"

base_price = 50
discount = 1.0  # 默认无折扣

if (is_student or age >= 60) and is_member:
    discount = 0.5  # 5折
    print("学生/老人会员优惠")
elif is_student or age >= 60:
    discount = 0.5  # 半价
    print("学生/老人优惠")
elif is_member:
    discount = 0.8  # 8折
    print("会员优惠")

final_price = base_price * discount
print(f"票价：{final_price}元")
```

## 小结
- 比较运算符：`==`、`!=`、`>`、`<`、`>=`、`<=`
- 逻辑运算符：`and`（与）、`or`（或）、`not`（非）
- `and` 要求所有条件都为真
- `or` 只要有一个条件为真
- 可以使用链式比较简化代码
- 注意运算符优先级

---
**上一课**: [第6课 - 条件语句](./第6课_条件语句.md)  
**下一课**: [第8课 - while循环](./第8课_while循环.md)
