# 第6课：条件语句 (if/else)

## 学习目标
- 理解条件判断的概念
- 掌握 if、elif、else 的使用
- 学会编写简单的判断逻辑

## 课程内容

### 什么是条件语句？
条件语句让程序根据不同情况做出不同的决定。

### if 语句

```python
age = 18

if age >= 18:
    print("你已经成年了")
    print("可以考驾照了")
```

**注意**：
- 条件后面要加冒号 `:`
- 条件成立后执行的代码要缩进（通常4个空格）

### if-else 语句

```python
age = 15

if age >= 18:
    print("你已经成年了")
else:
    print("你还未成年")
```

### if-elif-else 语句
多个条件判断：

```python
score = 85

if score >= 90:
    print("优秀")
elif score >= 80:
    print("良好")
elif score >= 60:
    print("及格")
else:
    print("不及格")
```

### 条件判断符号

```python
# 等于
if x == 5:
    print("x等于5")

# 不等于
if x != 5:
    print("x不等于5")

# 大于
if x > 5:
    print("x大于5")

# 小于
if x < 5:
    print("x小于5")

# 大于等于
if x >= 5:
    print("x大于等于5")

# 小于等于
if x <= 5:
    print("x小于等于5")
```

### 实际应用示例

#### 示例1：判断奇偶数
```python
number = int(input("请输入一个整数："))

if number % 2 == 0:
    print(f"{number}是偶数")
else:
    print(f"{number}是奇数")
```

#### 示例2：成绩等级
```python
score = int(input("请输入成绩："))

if score >= 90:
    grade = "A"
elif score >= 80:
    grade = "B"
elif score >= 70:
    grade = "C"
elif score >= 60:
    grade = "D"
else:
    grade = "F"

print(f"你的等级是：{grade}")
```

#### 示例3：温度提醒
```python
temperature = int(input("请输入当前温度："))

if temperature >= 35:
    print("天气炎热，注意防暑！")
elif temperature >= 25:
    print("天气温暖，适合出行")
elif temperature >= 15:
    print("天气凉爽，记得加件外套")
else:
    print("天气寒冷，注意保暖！")
```

### 嵌套条件语句
条件语句可以嵌套使用：

```python
age = int(input("请输入年龄："))
has_ticket = input("是否有票？(是/否)：")

if age >= 18:
    if has_ticket == "是":
        print("可以入场")
    else:
        print("请先购票")
else:
    print("未成年人不能入场")
```

## 练习题

### 练习1：判断正负数
编写程序，输入一个数字，判断它是正数、负数还是零。

### 练习2：BMI健康评估
根据BMI值给出健康建议：
- BMI < 18.5：体重过轻
- 18.5 <= BMI < 24：体重正常
- 24 <= BMI < 28：体重过重
- BMI >= 28：肥胖

### 练习3：简单登录系统
设定一个用户名和密码，让用户输入，判断是否正确。

### 参考答案
```python
# 练习1：判断正负数
number = float(input("请输入一个数字："))

if number > 0:
    print(f"{number}是正数")
elif number < 0:
    print(f"{number}是负数")
else:
    print("这个数是零")

# 练习2：BMI健康评估
print("\n=== BMI健康评估 ===")
weight = float(input("请输入体重（公斤）："))
height = float(input("请输入身高（米）："))

bmi = weight / (height ** 2)
print(f"你的BMI是：{bmi:.2f}")

if bmi < 18.5:
    print("评估：体重过轻，建议增加营养")
elif bmi < 24:
    print("评估：体重正常，请保持")
elif bmi < 28:
    print("评估：体重过重，建议适当运动")
else:
    print("评估：肥胖，建议咨询医生")

# 练习3：简单登录系统
print("\n=== 登录系统 ===")
correct_username = "admin"
correct_password = "123456"

username = input("请输入用户名：")
password = input("请输入密码：")

if username == correct_username:
    if password == correct_password:
        print("登录成功！欢迎回来！")
    else:
        print("密码错误！")
else:
    print("用户名不存在！")
```

## 小结
- `if` 语句用于条件判断
- `elif` 用于多个条件判断
- `else` 处理所有其他情况
- 条件后要加冒号，执行代码要缩进
- 可以使用嵌套条件语句处理复杂逻辑

---
**上一课**: [第5课 - 类型转换](./第5课_类型转换.md)  
**下一课**: [第7课 - 比较和逻辑运算符](./第7课_比较和逻辑运算符.md)
