# 第5课：类型转换

## 学习目标
- 理解为什么需要类型转换
- 掌握常用的类型转换函数
- 学会处理转换错误

## 课程内容

### 为什么需要类型转换？

```python
# input() 返回的是字符串
age = input("请输入年龄：")  # 假设输入 18
print(type(age))  # <class 'str'>

# 不能直接进行数学运算
# next_year = age + 1  # 错误！不能将字符串和数字相加
```

### 转换为整数：int()

```python
# 字符串转整数
age_str = "18"
age_int = int(age_str)
print(age_int)       # 18
print(type(age_int)) # <class 'int'>

# 浮点数转整数（会截断小数部分）
price = 19.99
price_int = int(price)
print(price_int)  # 19
```

### 转换为浮点数：float()

```python
# 字符串转浮点数
price_str = "19.99"
price_float = float(price_str)
print(price_float)       # 19.99
print(type(price_float)) # <class 'float'>

# 整数转浮点数
age = 18
age_float = float(age)
print(age_float)  # 18.0
```

### 转换为字符串：str()

```python
# 数字转字符串
age = 18
age_str = str(age)
print(age_str)       # 18
print(type(age_str)) # <class 'str'>

# 拼接时需要转换
name = "小明"
age = 18
message = name + "今年" + str(age) + "岁"
print(message)  # 小明今年18岁
```

### 转换为布尔值：bool()

```python
# 数字转布尔值
print(bool(1))    # True
print(bool(0))    # False
print(bool(100))  # True
print(bool(-5))   # True

# 字符串转布尔值
print(bool("hello"))  # True
print(bool(""))       # False (空字符串为False)
```

### 实际应用示例

#### 示例1：年龄计算
```python
print("=== 年龄计算器 ===")
current_year = 2024
birth_year = input("请输入你的出生年份：")

# 转换为整数才能计算
birth_year = int(birth_year)
age = current_year - birth_year

print(f"你今年{age}岁了！")
```

#### 示例2：购物计算
```python
print("=== 购物计算 ===")
price = input("请输入商品价格：")
quantity = input("请输入购买数量：")

# 转换为数字
price = float(price)
quantity = int(quantity)

total = price * quantity
print(f"总价：{total}元")
```

#### 示例3：温度转换
```python
print("=== 温度转换器 ===")
celsius = input("请输入摄氏温度：")

# 转换为浮点数
celsius = float(celsius)
fahrenheit = celsius * 9/5 + 32

print(f"{celsius}°C = {fahrenheit}°F")
```

### 类型转换注意事项

```python
# 1. 不是所有字符串都能转换为数字
# num = int("abc")  # 错误！会报错

# 2. 浮点数字符串不能直接转为整数
# num = int("19.99")  # 错误！
# 正确做法：先转为float，再转为int
num = int(float("19.99"))
print(num)  # 19

# 3. 空字符串转数字会报错
# num = int("")  # 错误！
```

## 练习题

### 练习1：BMI计算器
编写程序计算BMI（身体质量指数）：
1. 输入体重（公斤）
2. 输入身高（米）
3. 计算BMI = 体重 / (身高²)
4. 输出结果

### 练习2：找零计算
编写程序：
1. 输入商品价格
2. 输入支付金额
3. 计算应找零金额
4. 输出结果

### 练习3：数字游戏
编写程序：
1. 输入一个整数
2. 计算这个数的2倍、3倍、平方
3. 输出所有结果

### 参考答案
```python
# 练习1：BMI计算器
print("=== BMI计算器 ===")
weight = input("请输入体重（公斤）：")
height = input("请输入身高（米）：")

weight = float(weight)
height = float(height)

bmi = weight / (height ** 2)
print(f"你的BMI是：{bmi:.2f}")

# 练习2：找零计算
print("\n=== 找零计算 ===")
price = input("请输入商品价格：")
payment = input("请输入支付金额：")

price = float(price)
payment = float(payment)

change = payment - price

if change >= 0:
    print(f"应找零：{change:.2f}元")
else:
    print(f"金额不足，还差：{-change:.2f}元")

# 练习3：数字游戏
print("\n=== 数字游戏 ===")
number = input("请输入一个整数：")
number = int(number)

double = number * 2
triple = number * 3
square = number ** 2

print(f"原数字：{number}")
print(f"2倍：{double}")
print(f"3倍：{triple}")
print(f"平方：{square}")
```

## 小结
- `int()` 将其他类型转换为整数
- `float()` 将其他类型转换为浮点数
- `str()` 将其他类型转换为字符串
- `bool()` 将其他类型转换为布尔值
- 使用 `input()` 获取数字时，记得转换类型
- 注意转换时可能出现的错误

---
**上一课**: [第4课 - 用户输入和输出](./第4课_用户输入和输出.md)  
**下一课**: [第6课 - 条件语句](./第6课_条件语句.md)
