# 第4课：用户输入和输出

## 学习目标
- 学会使用 `print()` 输出信息
- 掌握 `input()` 获取用户输入
- 理解输入输出的基本应用

## 课程内容

### 输出：print() 函数

#### 基本输出
```python
print("Hello, Python!")
print("你好，世界！")
```

#### 输出多个值
```python
name = "小明"
age = 18
print("姓名:", name, "年龄:", age)
# 输出：姓名: 小明 年龄: 18
```

#### 自定义分隔符
```python
print("苹果", "香蕉", "橙子", sep=", ")
# 输出：苹果, 香蕉, 橙子

print("2024", "12", "25", sep="-")
# 输出：2024-12-25
```

#### 控制结尾
```python
# 默认print会换行
print("第一行")
print("第二行")

# 使用end参数不换行
print("姓名:", end=" ")
print("小明")
# 输出：姓名: 小明
```

### 输入：input() 函数

#### 获取用户输入
```python
name = input("请输入你的姓名：")
print("你好，" + name + "！")
```

#### 注意：input() 返回的是字符串
```python
# 输入的内容都是字符串类型
age = input("请输入你的年龄：")
print(type(age))  # <class 'str'>
```

### 输入与输出结合

```python
# 获取用户信息
name = input("请输入你的姓名：")
city = input("请输入你的城市：")

# 输出欢迎信息
print("=" * 30)
print(f"欢迎 {name} 来自 {city}！")
print("=" * 30)
```

### 格式化输出

#### 使用 f-string
```python
name = "小红"
score = 95.5

print(f"学生：{name}")
print(f"成绩：{score}分")
print(f"{name}的成绩是{score}分")
```

#### 对齐和填充
```python
# 左对齐
print(f"{'姓名':<10}{'年龄':<5}")
print(f"{'张三':<10}{18:<5}")

# 右对齐
print(f"{'姓名':>10}{'年龄':>5}")
print(f"{'张三':>10}{18:>5}")

# 居中对齐
print(f"{'标题':=^20}")  # 用=填充，居中对齐
```

### 实用示例

#### 简单的问候程序
```python
print("欢迎使用问候程序！")
print("-" * 30)

name = input("请输入你的姓名：")
age = input("请输入你的年龄：")

print("\n" + "=" * 30)
print(f"你好，{name}！")
print(f"你今年{age}岁了。")
print("=" * 30)
```

## 练习题

### 练习1：个人信息收集
编写程序，依次询问用户：
- 姓名
- 年龄
- 爱好

然后用格式化的方式输出这些信息。

### 练习2：简单计算器
编写程序：
1. 提示用户输入第一个数字
2. 提示用户输入第二个数字
3. 计算两个数字的和（注意：需要类型转换）
4. 输出结果

### 练习3：制作名片
使用输入输出功能，制作一张简单的文字名片，包含：
- 姓名
- 职位
- 电话
- 邮箱

用美观的格式输出。

### 参考答案
```python
# 练习1
print("=== 个人信息收集 ===")
name = input("请输入你的姓名：")
age = input("请输入你的年龄：")
hobby = input("请输入你的爱好：")

print("\n" + "=" * 40)
print(f"姓名：{name}")
print(f"年龄：{age}岁")
print(f"爱好：{hobby}")
print("=" * 40)

# 练习2
print("=== 简单计算器 ===")
num1 = input("请输入第一个数字：")
num2 = input("请输入第二个数字：")

# 转换为数字
num1 = float(num1)
num2 = float(num2)

result = num1 + num2
print(f"{num1} + {num2} = {result}")

# 练习3
print("=== 名片制作 ===")
name = input("请输入姓名：")
position = input("请输入职位：")
phone = input("请输入电话：")
email = input("请输入邮箱：")

print("\n" + "╔" + "═" * 38 + "╗")
print(f"║ {'名片':^34} ║")
print("╠" + "═" * 38 + "╣")
print(f"║  姓名：{name:<28} ║")
print(f"║  职位：{position:<28} ║")
print(f"║  电话：{phone:<28} ║")
print(f"║  邮箱：{email:<28} ║")
print("╚" + "═" * 38 + "╝")
```

## 小结
- `print()` 用于输出信息，可以输出多个值
- `input()` 用于获取用户输入，返回字符串类型
- f-string 是格式化输出的推荐方式
- 可以使用 `sep` 和 `end` 参数控制输出格式

---
**上一课**: [第3课 - 字符串基础](./第3课_字符串基础.md)  
**下一课**: [第5课 - 类型转换](./第5课_类型转换.md)
