# 第3课：字符串基础

## 学习目标
- 掌握字符串的创建和使用
- 学会字符串的基本操作
- 了解字符串的常用方法

## 课程内容

### 创建字符串
字符串可以用单引号或双引号创建：

```python
name1 = '张三'
name2 = "李四"
message = "你好，世界！"

print(name1)
print(name2)
print(message)
```

### 字符串拼接
使用 `+` 号可以连接字符串：

```python
first_name = "张"
last_name = "三"
full_name = first_name + last_name
print(full_name)  # 张三

greeting = "你好，" + full_name + "！"
print(greeting)  # 你好，张三！
```

### 字符串重复
使用 `*` 号可以重复字符串：

```python
star = "★"
stars = star * 5
print(stars)  # ★★★★★

line = "-" * 20
print(line)  # --------------------
```

### 字符串长度
使用 `len()` 函数获取字符串长度：

```python
text = "Python编程"
length = len(text)
print(length)  # 8
```

### 访问字符串中的字符
使用索引（从0开始）访问单个字符：

```python
word = "Python"
print(word[0])  # P (第一个字符)
print(word[1])  # y (第二个字符)
print(word[-1]) # n (最后一个字符)
print(word[-2]) # o (倒数第二个字符)
```

### 字符串切片
获取字符串的一部分：

```python
text = "Hello World"
print(text[0:5])   # Hello (从索引0到4)
print(text[6:11])  # World (从索引6到10)
print(text[:5])    # Hello (从开始到索引4)
print(text[6:])    # World (从索引6到结束)
```

### 常用字符串方法

```python
text = "hello python"

# 转换为大写
print(text.upper())  # HELLO PYTHON

# 转换为小写
print(text.lower())  # hello python

# 首字母大写
print(text.capitalize())  # Hello python

# 每个单词首字母大写
print(text.title())  # Hello Python

# 去除空格
text2 = "  hello  "
print(text2.strip())  # hello
```

### 字符串格式化
使用 f-string（推荐方式）：

```python
name = "小明"
age = 18
height = 1.75

# f-string 格式化
message = f"我叫{name}，今年{age}岁，身高{height}米"
print(message)
# 输出：我叫小明，今年18岁，身高1.75米
```

## 练习题

### 练习1：个人介绍
创建变量存储你的姓名、年龄和城市，然后用字符串拼接或f-string创建一句完整的自我介绍。

### 练习2：字符串操作
给定字符串 "python programming"：
- 将它转换为大写
- 获取前6个字符
- 获取后11个字符
- 计算字符串长度

### 练习3：制作分隔线
使用字符串重复，创建一个由30个等号组成的分隔线。

### 参考答案
```python
# 练习1
name = "小红"
age = 20
city = "上海"

# 方法1：字符串拼接
intro1 = "大家好，我叫" + name + "，今年" + str(age) + "岁，来自" + city + "。"
print(intro1)

# 方法2：f-string（推荐）
intro2 = f"大家好，我叫{name}，今年{age}岁，来自{city}。"
print(intro2)

# 练习2
text = "python programming"
print(text.upper())      # PYTHON PROGRAMMING
print(text[:6])          # python
print(text[-11:])        # programming
print(len(text))         # 18

# 练习3
separator = "=" * 30
print(separator)         # ==============================
```

## 小结
- 字符串用引号创建，单引号和双引号都可以
- 使用 `+` 拼接字符串，`*` 重复字符串
- 使用 `len()` 获取长度
- 索引从0开始，负数索引从末尾开始
- f-string 是格式化字符串的推荐方式

---
**上一课**: [第2课 - 数字运算](./第2课_数字运算.md)  
**下一课**: [第4课 - 用户输入和输出](./第4课_用户输入和输出.md)
