# 第2课：数字运算

## 学习目标
- 掌握Python的基本数学运算
- 学会使用算术运算符
- 理解运算优先级

## 课程内容

### 基本算术运算符

```python
# 加法
result = 10 + 5
print(result)  # 15

# 减法
result = 10 - 5
print(result)  # 5

# 乘法
result = 10 * 5
print(result)  # 50

# 除法
result = 10 / 5
print(result)  # 2.0 (结果是浮点数)
```

### 其他运算符

```python
# 整除 (去掉小数部分)
result = 10 // 3
print(result)  # 3

# 取余数
result = 10 % 3
print(result)  # 1

# 幂运算 (次方)
result = 2 ** 3
print(result)  # 8 (2的3次方)
```

### 运算优先级
和数学一样，Python也有运算优先级：

```python
# 先乘除，后加减
result = 2 + 3 * 4
print(result)  # 14

# 使用括号改变优先级
result = (2 + 3) * 4
print(result)  # 20
```

优先级顺序（从高到低）：
1. 括号 `()`
2. 幂运算 `**`
3. 乘、除、整除、取余 `*  /  //  %`
4. 加、减 `+  -`

### 变量运算

```python
a = 10
b = 3

sum_result = a + b
print(sum_result)  # 13

difference = a - b
print(difference)  # 7

product = a * b
print(product)  # 30
```

### 复合赋值运算符
简化的写法：

```python
number = 10

# 等同于 number = number + 5
number += 5
print(number)  # 15

# 等同于 number = number - 3
number -= 3
print(number)  # 12

# 等同于 number = number * 2
number *= 2
print(number)  # 24

# 等同于 number = number / 4
number /= 4
print(number)  # 6.0
```

## 练习题

### 练习1：计算商品价格
假设你买了以下商品：
- 苹果：3个，每个5元
- 香蕉：2斤，每斤8元
- 橙子：4个，每个6元

计算总价格。

### 练习2：计算平均分
小明的三科成绩分别是：
- 语文：85分
- 数学：92分
- 英语：88分

计算平均分。

### 练习3：温度转换
将摄氏温度25度转换为华氏温度。
公式：华氏度 = 摄氏度 × 9/5 + 32

### 参考答案
```python
# 练习1
apples = 3 * 5
bananas = 2 * 8
oranges = 4 * 6
total = apples + bananas + oranges
print("总价格:", total, "元")  # 总价格: 55 元

# 练习2
chinese = 85
math = 92
english = 88
average = (chinese + math + english) / 3
print("平均分:", average)  # 平均分: 88.33333333333333

# 练习3
celsius = 25
fahrenheit = celsius * 9/5 + 32
print("华氏温度:", fahrenheit)  # 华氏温度: 77.0
```

## 小结
- Python支持基本的算术运算：+、-、*、/
- 特殊运算符：//（整除）、%（取余）、**（幂运算）
- 运算有优先级，可以用括号改变
- 复合赋值运算符可以简化代码

---
**上一课**: [第1课 - 变量和数据类型](./第1课_变量和数据类型.md)  
**下一课**: [第3课 - 字符串基础](./第3课_字符串基础.md)
