# 第21课：类

## 学习目标
- 理解面向对象编程的概念
- 学会定义和使用类
- 掌握类的属性和方法
- 理解self的作用

## 课程内容

### 什么是类？
类是创建对象的模板，可以把相关的数据和功能组织在一起。

```python
# 定义一个简单的类
class Dog:
    def bark(self):
        print("汪汪汪！")

# 创建对象（实例化）
my_dog = Dog()
my_dog.bark()  # 汪汪汪！
```

### 类的属性

```python
class Student:
    def __init__(self, name, age):
        self.name = name  # 实例属性
        self.age = age
    
    def introduce(self):
        print(f"我叫{self.name}，今年{self.age}岁")

# 创建学生对象
student1 = Student("张三", 18)
student1.introduce()  # 我叫张三，今年18岁

student2 = Student("李四", 20)
student2.introduce()  # 我叫李四，今年20岁
```

### __init__ 方法
`__init__` 是构造方法，在创建对象时自动调用。

```python
class Car:
    def __init__(self, brand, color):
        self.brand = brand
        self.color = color
        self.speed = 0
    
    def start(self):
        print(f"{self.color}的{self.brand}启动了！")
    
    def accelerate(self, speed):
        self.speed += speed
        print(f"加速到{self.speed}公里/小时")

my_car = Car("宝马", "黑色")
my_car.start()        # 黑色的宝马启动了！
my_car.accelerate(60) # 加速到60公里/小时
```

### self 的作用
`self` 代表类的实例本身，用于访问实例的属性和方法。

```python
class Counter:
    def __init__(self):
        self.count = 0  # 实例属性
    
    def increment(self):
        self.count += 1
    
    def get_count(self):
        return self.count

counter = Counter()
counter.increment()
counter.increment()
print(counter.get_count())  # 2
```

### 实用示例

#### 示例1：银行账户
```python
class BankAccount:
    def __init__(self, owner, balance=0):
        self.owner = owner
        self.balance = balance
    
    def deposit(self, amount):
        self.balance += amount
        print(f"存入{amount}元，余额：{self.balance}元")
    
    def withdraw(self, amount):
        if amount <= self.balance:
            self.balance -= amount
            print(f"取出{amount}元，余额：{self.balance}元")
        else:
            print("余额不足！")
    
    def show_balance(self):
        print(f"{self.owner}的账户余额：{self.balance}元")

account = BankAccount("张三", 1000)
account.show_balance()  # 张三的账户余额：1000元
account.deposit(500)    # 存入500元，余额：1500元
account.withdraw(300)   # 取出300元，余额：1200元
```

#### 示例2：图书管理
```python
class Book:
    def __init__(self, title, author, price):
        self.title = title
        self.author = author
        self.price = price
        self.is_borrowed = False
    
    def borrow(self):
        if not self.is_borrowed:
            self.is_borrowed = True
            print(f"《{self.title}》借阅成功")
        else:
            print(f"《{self.title}》已被借出")
    
    def return_book(self):
        self.is_borrowed = False
        print(f"《{self.title}》归还成功")
    
    def info(self):
        status = "已借出" if self.is_borrowed else "可借阅"
        print(f"书名：《{self.title}》")
        print(f"作者：{self.author}")
        print(f"价格：{self.price}元")
        print(f"状态：{status}")

book = Book("Python入门", "张老师", 59)
book.info()
book.borrow()
book.borrow()  # 已被借出
book.return_book()
```

## 练习题

### 练习1：创建手机类
创建一个 `Phone` 类，包含品牌、型号、电量属性，以及打电话、充电的方法。

### 练习2：学生成绩管理
创建 `Student` 类，可以添加成绩、计算平均分、显示学生信息。

### 参考答案
```python
# 练习1
class Phone:
    def __init__(self, brand, model):
        self.brand = brand
        self.model = model
        self.battery = 100
    
    def call(self, number):
        if self.battery > 10:
            self.battery -= 10
            print(f"正在拨打{number}...")
            print(f"剩余电量：{self.battery}%")
        else:
            print("电量不足，请充电！")
    
    def charge(self):
        self.battery = 100
        print("充电完成，电量100%")

phone = Phone("华为", "Mate 50")
phone.call("10086")
phone.call("10010")
phone.charge()

# 练习2
class Student:
    def __init__(self, name, student_id):
        self.name = name
        self.student_id = student_id
        self.scores = []
    
    def add_score(self, subject, score):
        self.scores.append({"科目": subject, "成绩": score})
        print(f"已添加{subject}成绩：{score}分")
    
    def average(self):
        if len(self.scores) == 0:
            return 0
        total = sum(item["成绩"] for item in self.scores)
        return total / len(self.scores)
    
    def show_info(self):
        print(f"\n学生姓名：{self.name}")
        print(f"学号：{self.student_id}")
        print("成绩列表：")
        for item in self.scores:
            print(f"  {item['科目']}：{item['成绩']}分")
        print(f"平均分：{self.average():.2f}分")

student = Student("王小明", "2024001")
student.add_score("数学", 95)
student.add_score("语文", 88)
student.add_score("英语", 92)
student.show_info()
```

## 小结
- 使用 `class` 关键字定义类
- `__init__` 方法用于初始化对象
- `self` 代表实例本身
- 类可以包含属性（数据）和方法（功能）
- 通过类可以创建多个对象
- 面向对象让代码更有组织性和可维护性

---
**上一课**: [第20课 - 文件写入](./第20课_文件写入.md)
