# 第20课：文件写入

## 学习目标
- 学会写入文件
- 掌握追加模式
- 理解文件操作模式

## 课程内容

### 写入文件

```python
# 写入模式（会覆盖原内容）
with open("output.txt", "w", encoding="utf-8") as f:
    f.write("Hello, Python!\n")
    f.write("这是第二行")
```

### 追加模式

```python
# 追加模式（在文件末尾添加）
with open("output.txt", "a", encoding="utf-8") as f:
    f.write("\n这是追加的内容")
```

### 文件模式

- `"r"` - 读取（默认）
- `"w"` - 写入（覆盖）
- `"a"` - 追加
- `"r+"` - 读写

### 实用示例

```python
# 日志记录
def write_log(message):
    with open("log.txt", "a", encoding="utf-8") as f:
        from datetime import datetime
        time = datetime.now().strftime("%Y-%m-%d %H:%M:%S")
        f.write(f"[{time}] {message}\n")

write_log("程序启动")
write_log("用户登录")
```

## 练习题

### 练习1：学生成绩记录
创建程序，将学生姓名和成绩写入文件。

### 练习2：日记本
创建简单的日记程序，可以追加日记内容。

### 参考答案
```python
# 练习1
students = [
    ("张三", 85),
    ("李四", 92),
    ("王五", 78)
]

with open("scores.txt", "w", encoding="utf-8") as f:
    f.write("学生成绩表\n")
    f.write("=" * 20 + "\n")
    for name, score in students:
        f.write(f"{name}: {score}分\n")

print("成绩已保存到 scores.txt")

# 练习2
def diary():
    print("=== 简易日记本 ===")
    content = input("请输入今天的日记：")
    
    with open("diary.txt", "a", encoding="utf-8") as f:
        from datetime import datetime
        date = datetime.now().strftime("%Y年%m月%d日")
        f.write(f"\n{date}\n")
        f.write(content + "\n")
        f.write("-" * 30 + "\n")
    
    print("日记已保存！")

# diary()  # 取消注释运行
```

## 小结
- `"w"` 模式写入文件（覆盖）
- `"a"` 模式追加内容
- write() 写入字符串
- 使用 with 语句确保文件正确关闭
- 可以用文件保存程序数据

---
**上一课**: [第19课 - 文件读取](./第19课_文件读取.md)

## 🎉 恭喜完成全部20课！

你已经学完了Python入门的所有基础知识：
- ✅ 变量和数据类型
- ✅ 运算符和表达式
- ✅ 控制流程（if/while/for）
- ✅ 数据结构（列表/元组/字典）
- ✅ 函数
- ✅ 文件操作

继续练习，多写代码，你会越来越熟练！加油！🐍
