# 第1课：变量和数据类型

## 学习目标
- 理解什么是变量
- 学会创建和使用变量
- 认识Python的基本数据类型

## 课程内容

### 什么是变量？
变量就像一个盒子，可以存储数据。你可以给这个盒子起个名字，然后往里面放东西。

### 创建变量
在Python中，创建变量非常简单：

```python
# 创建一个变量
name = "小明"
age = 18
height = 1.75
is_student = True
```

### 基本数据类型

1. **字符串 (str)** - 文本数据
```python
name = "张三"
city = "北京"
```

2. **整数 (int)** - 整数
```python
age = 25
year = 2024
```

3. **浮点数 (float)** - 小数
```python
price = 19.99
temperature = 36.5
```

4. **布尔值 (bool)** - 真或假
```python
is_sunny = True
is_raining = False
```

### 查看变量类型
使用 `type()` 函数可以查看变量的类型：

```python
name = "李四"
print(type(name))  # <class 'str'>

age = 30
print(type(age))   # <class 'int'>
```

### 变量命名规则
- 只能包含字母、数字和下划线
- 不能以数字开头
- 区分大小写
- 不能使用Python关键字

```python
# 正确的命名
user_name = "王五"
age1 = 20
_temp = 100

# 错误的命名
# 2name = "错误"  # 不能以数字开头
# user-name = "错误"  # 不能使用连字符
```

## 练习题

### 练习1：创建个人信息变量
创建以下变量来存储你的个人信息：
- 姓名 (字符串)
- 年龄 (整数)
- 身高 (浮点数，单位：米)
- 是否是学生 (布尔值)

然后使用 `print()` 打印这些变量。

### 练习2：查看数据类型
使用 `type()` 函数查看你创建的每个变量的数据类型。

### 参考答案
```python
# 练习1
name = "小红"
age = 20
height = 1.65
is_student = True

print(name)
print(age)
print(height)
print(is_student)

# 练习2
print(type(name))       # <class 'str'>
print(type(age))        # <class 'int'>
print(type(height))     # <class 'float'>
print(type(is_student)) # <class 'bool'>
```

## 小结
- 变量用于存储数据
- Python有四种基本数据类型：字符串、整数、浮点数、布尔值
- 使用 `type()` 可以查看变量类型
- 变量命名要遵循规则

---
**下一课**: [第2课 - 数字运算](./第2课_数字运算.md)
