# 第19课：文件读取

## 学习目标
- 学会打开和读取文件
- 掌握不同的读取方法
- 理解文件操作的基本流程

## 课程内容

### 打开文件

```python
# 打开文件
file = open("test.txt", "r", encoding="utf-8")
content = file.read()
print(content)
file.close()
```

### 使用 with 语句（推荐）

```python
with open("test.txt", "r", encoding="utf-8") as file:
    content = file.read()
    print(content)
# 文件自动关闭
```

### 读取方法

```python
# read() - 读取全部
with open("test.txt", "r", encoding="utf-8") as f:
    content = f.read()

# readline() - 读取一行
with open("test.txt", "r", encoding="utf-8") as f:
    line = f.readline()

# readlines() - 读取所有行
with open("test.txt", "r", encoding="utf-8") as f:
    lines = f.readlines()
    for line in lines:
        print(line.strip())
```

## 练习题

### 练习1：读取文件
创建一个文本文件，读取并打印内容。

### 参考答案
```python
# 先创建文件
with open("test.txt", "w", encoding="utf-8") as f:
    f.write("第一行\n第二行\n第三行")

# 读取文件
with open("test.txt", "r", encoding="utf-8") as f:
    content = f.read()
    print(content)
```

## 小结
- open() 打开文件
- read() 读取全部内容
- readline() 读取一行
- readlines() 读取所有行
- 使用 with 语句自动关闭文件

---
**上一课**: [第18课 - 返回值](./第18课_返回值.md)  
**下一课**: [第20课 - 文件写入](./第20课_文件写入.md)
