# 第17课：函数参数

## 学习目标
- 掌握默认参数的使用
- 学会关键字参数
- 理解可变参数

## 课程内容

### 默认参数

```python
def greet(name, greeting="你好"):
    print(f"{greeting}，{name}！")

greet("张三")           # 你好，张三！
greet("李四", "早上好")  # 早上好，李四！
```

### 关键字参数

```python
def introduce(name, age, city):
    print(f"我叫{name}，{age}岁，来自{city}")

introduce(name="李四", city="上海", age=20)
```

### 可变参数

```python
def sum_all(*numbers):
    total = 0
    for num in numbers:
        total += num
    return total

print(sum_all(1, 2, 3))  # 6
```

## 练习题

### 练习1：个人信息函数
创建函数，接收姓名、年龄和城市（默认"北京"）。

### 参考答案
```python
def person_info(name, age, city="北京"):
    print(f"{name}，{age}岁，来自{city}")

person_info("张三", 18)
person_info("李四", 20, "上海")
```

## 小结
- 默认参数提供默认值
- 关键字参数可以指定参数名
- 可变参数接收任意数量的参数

---
**上一课**: [第16课 - 函数定义和调用](./第16课_函数定义和调用.md)  
**下一课**: [第18课 - 返回值](./第18课_返回值.md)
