# 第16课：函数定义和调用

## 学习目标
- 理解函数的概念
- 学会定义和调用函数
- 掌握函数的基本用法

## 课程内容

### 什么是函数？
函数是一段可重复使用的代码块。

```python
# 定义函数
def greet():
    print("你好！")
    print("欢迎学习Python")

# 调用函数
greet()
```

### 函数的基本结构

```python
def function_name():
    # 函数体
    # 要执行的代码
    pass
```

### 带参数的函数

```python
def greet(name):
    print(f"你好，{name}！")

greet("张三")  # 你好，张三！
greet("李四")  # 你好，李四！
```

### 多个参数

```python
def add(a, b):
    result = a + b
    print(f"{a} + {b} = {result}")

add(3, 5)   # 3 + 5 = 8
add(10, 20) # 10 + 20 = 30
```

### 实用示例

#### 示例1：打印分隔线
```python
def print_line():
    print("=" * 30)

print_line()
print("标题")
print_line()
```

#### 示例2：计算面积
```python
def rectangle_area(length, width):
    area = length * width
    print(f"长方形面积：{area}")

rectangle_area(5, 3)  # 长方形面积：15
```

## 练习题

### 练习1：自我介绍函数
创建一个函数，接收姓名和年龄，打印自我介绍。

### 练习2：计算器函数
创建加、减、乘、除四个函数。

### 参考答案
```python
# 练习1
def introduce(name, age):
    print(f"大家好，我叫{name}，今年{age}岁。")

introduce("小明", 18)

# 练习2
def add(a, b):
    print(f"{a} + {b} = {a + b}")

def subtract(a, b):
    print(f"{a} - {b} = {a - b}")

def multiply(a, b):
    print(f"{a} × {b} = {a * b}")

def divide(a, b):
    if b != 0:
        print(f"{a} ÷ {b} = {a / b}")
    else:
        print("不能除以0")

add(10, 5)
subtract(10, 5)
multiply(10, 5)
divide(10, 5)
```

## 小结
- 使用 `def` 定义函数
- 函数可以接收参数
- 调用函数时传入参数值
- 函数让代码更简洁、可重用

---
**上一课**: [第15课 - 字典操作](./第15课_字典操作.md)  
**下一课**: [第17课 - 函数参数](./第17课_函数参数.md)
