# 第15课：字典操作

## 学习目标
- 掌握字典的高级操作
- 学会字典的更新和合并
- 理解嵌套字典的使用

## 课程内容

### 字典的更新

#### update() - 更新字典
```python
student = {"name": "张三", "age": 18}
new_info = {"age": 19, "city": "北京"}

student.update(new_info)
print(student)
# {'name': '张三', 'age': 19, 'city': '北京'}
```

#### setdefault() - 设置默认值
```python
student = {"name": "张三", "age": 18}

# 如果键存在，返回值
name = student.setdefault("name", "李四")
print(name)  # 张三

# 如果键不存在，添加键值对并返回值
city = student.setdefault("city", "上海")
print(city)     # 上海
print(student)  # {'name': '张三', 'age': 18, 'city': '上海'}
```

### 字典推导式

```python
# 创建平方字典
squares = {x: x**2 for x in range(1, 6)}
print(squares)  # {1: 1, 2: 4, 3: 9, 4: 16, 5: 25}

# 筛选字典
scores = {"张三": 85, "李四": 92, "王五": 78, "赵六": 95}
high_scores = {name: score for name, score in scores.items() if score >= 90}
print(high_scores)  # {'李四': 92, '赵六': 95}
```

### 嵌套字典

```python
# 学生信息（字典中包含字典）
students = {
    "001": {
        "name": "张三",
        "age": 18,
        "scores": {"语文": 85, "数学": 92}
    },
    "002": {
        "name": "李四",
        "age": 19,
        "scores": {"语文": 90, "数学": 88}
    }
}

# 访问嵌套字典
print(students["001"]["name"])  # 张三
print(students["001"]["scores"]["数学"])  # 92
```

## 练习题

### 练习1：班级成绩管理
创建一个字典存储班级学生信息，计算每个学生的平均分。

### 练习2：商品销售统计
统计每种商品的总销售额。

### 参考答案
```python
# 练习1
class_data = {
    "张三": {"语文": 85, "数学": 92, "英语": 88},
    "李四": {"语文": 90, "数学": 88, "英语": 95}
}

for name, scores in class_data.items():
    avg = sum(scores.values()) / len(scores)
    print(f"{name}的平均分：{avg:.2f}")

# 练习2
sales = [
    {"product": "苹果", "quantity": 10, "price": 5},
    {"product": "香蕉", "quantity": 15, "price": 3}
]

total_sales = {}
for sale in sales:
    product = sale["product"]
    amount = sale["quantity"] * sale["price"]
    total_sales[product] = total_sales.get(product, 0) + amount

print(total_sales)
```

## 小结
- `update()` 更新字典
- `setdefault()` 设置默认值
- 字典推导式快速创建字典
- 嵌套字典可以存储复杂数据

---
**上一课**: [第14课 - 字典基础](./第14课_字典基础.md)  
**下一课**: [第16课 - 函数定义和调用](./第16课_函数定义和调用.md)
