# 第14课：字典基础

## 学习目标
- 理解字典的概念
- 学会创建和访问字典
- 掌握字典的基本操作

## 课程内容

### 什么是字典？
字典是一种存储**键值对**（key-value）的数据结构。

```python
# 创建字典 - 使用花括号
student = {
    "name": "张三",
    "age": 18,
    "score": 95
}

print(student)
# {'name': '张三', 'age': 18, 'score': 95}
```

### 创建字典的方法

```python
# 方法1：使用花括号
dict1 = {"name": "张三", "age": 18}

# 方法2：空字典
dict2 = {}

# 方法3：使用dict()函数
dict3 = dict(name="李四", age=20)

# 方法4：从列表创建
pairs = [("name", "王五"), ("age", 22)]
dict4 = dict(pairs)

print(dict3)  # {'name': '李四', 'age': 20}
print(dict4)  # {'name': '王五', 'age': 22}
```

### 访问字典元素

```python
student = {
    "name": "张三",
    "age": 18,
    "city": "北京"
}

# 使用键访问值
print(student["name"])  # 张三
print(student["age"])   # 18

# 使用get()方法（推荐）
print(student.get("name"))  # 张三
print(student.get("phone"))  # None（键不存在时返回None）
print(student.get("phone", "未提供"))  # 未提供（可以指定默认值）
```

### 修改和添加元素

```python
student = {
    "name": "张三",
    "age": 18
}

# 修改已存在的键
student["age"] = 19
print(student)  # {'name': '张三', 'age': 19}

# 添加新的键值对
student["city"] = "上海"
print(student)  # {'name': '张三', 'age': 19, 'city': '上海'}
```

### 删除元素

```python
student = {
    "name": "张三",
    "age": 18,
    "city": "北京"
}

# del 删除指定键
del student["city"]
print(student)  # {'name': '张三', 'age': 18}

# pop() 删除并返回值
age = student.pop("age")
print(age)      # 18
print(student)  # {'name': '张三'}

# clear() 清空字典
student.clear()
print(student)  # {}
```

### 检查键是否存在

```python
student = {
    "name": "张三",
    "age": 18
}

# 使用 in 运算符
if "name" in student:
    print("name键存在")

if "phone" not in student:
    print("phone键不存在")
```

### 获取字典信息

```python
student = {
    "name": "张三",
    "age": 18,
    "city": "北京"
}

# 获取所有键
keys = student.keys()
print(keys)  # dict_keys(['name', 'age', 'city'])

# 获取所有值
values = student.values()
print(values)  # dict_values(['张三', 18, '北京'])

# 获取所有键值对
items = student.items()
print(items)  # dict_items([('name', '张三'), ('age', 18), ('city', '北京')])

# 字典长度
print(len(student))  # 3
```

### 遍历字典

```python
student = {
    "name": "张三",
    "age": 18,
    "city": "北京"
}

# 遍历键
print("=== 遍历键 ===")
for key in student:
    print(key)

# 遍历值
print("\n=== 遍历值 ===")
for value in student.values():
    print(value)

# 遍历键值对
print("\n=== 遍历键值对 ===")
for key, value in student.items():
    print(f"{key}: {value}")
```

### 实用示例

#### 示例1：学生信息管理
```python
student = {
    "name": "张三",
    "age": 18,
    "grade": "高三",
    "scores": {
        "语文": 85,
        "数学": 92,
        "英语": 88
    }
}

print(f"姓名：{student['name']}")
print(f"年龄：{student['age']}")
print(f"年级：{student['grade']}")

print("\n各科成绩：")
for subject, score in student["scores"].items():
    print(f"{subject}: {score}分")
```

#### 示例2：单词计数
```python
text = "python is great python is fun"
words = text.split()

word_count = {}
for word in words:
    if word in word_count:
        word_count[word] += 1
    else:
        word_count[word] = 1

print("单词统计：")
for word, count in word_count.items():
    print(f"{word}: {count}次")
```

#### 示例3：通讯录
```python
contacts = {
    "张三": "13800138000",
    "李四": "13900139000",
    "王五": "13700137000"
}

print("=== 通讯录 ===")
for name, phone in contacts.items():
    print(f"{name}: {phone}")

# 查找联系人
search_name = input("\n请输入要查找的姓名：")
if search_name in contacts:
    print(f"{search_name}的电话是：{contacts[search_name]}")
else:
    print("联系人不存在")
```

### 字典的特点

```python
# 1. 键必须是唯一的
dict1 = {"name": "张三", "name": "李四"}
print(dict1)  # {'name': '李四'} (后面的值会覆盖前面的)

# 2. 键必须是不可变类型（字符串、数字、元组）
# dict2 = {[1, 2]: "value"}  # 错误！列表不能作为键
dict3 = {(1, 2): "value"}  # 正确！元组可以作为键

# 3. 值可以是任何类型
dict4 = {
    "string": "文本",
    "number": 100,
    "list": [1, 2, 3],
    "dict": {"a": 1}
}
```

## 练习题

### 练习1：个人信息字典
创建一个字典存储你的个人信息：
- 姓名
- 年龄
- 城市
- 爱好（列表）

然后打印所有信息。

### 练习2：成绩管理
创建一个字典存储3个学生的成绩：
```python
scores = {
    "张三": 85,
    "李四": 92,
    "王五": 78
}
```
- 计算平均分
- 找出最高分的学生
- 添加一个新学生
- 删除一个学生

### 练习3：字符统计
输入一个字符串，统计每个字符出现的次数。
例如："hello" → {'h': 1, 'e': 1, 'l': 2, 'o': 1}

### 参考答案
```python
# 练习1：个人信息字典
print("=== 练习1：个人信息 ===")
my_info = {
    "姓名": "小明",
    "年龄": 20,
    "城市": "北京",
    "爱好": ["阅读", "运动", "编程"]
}

print("个人信息：")
for key, value in my_info.items():
    print(f"{key}: {value}")

# 练习2：成绩管理
print("\n=== 练习2：成绩管理 ===")
scores = {
    "张三": 85,
    "李四": 92,
    "王五": 78
}

# 计算平均分
total = sum(scores.values())
average = total / len(scores)
print(f"平均分：{average:.2f}")

# 找最高分
max_score = 0
top_student = ""
for name, score in scores.items():
    if score > max_score:
        max_score = score
        top_student = name

print(f"最高分：{top_student} - {max_score}分")

# 添加新学生
scores["赵六"] = 88
print(f"\n添加赵六后：{scores}")

# 删除学生
del scores["王五"]
print(f"删除王五后：{scores}")

# 练习3：字符统计
print("\n=== 练习3：字符统计 ===")
text = input("请输入一个字符串：")

char_count = {}
for char in text:
    if char in char_count:
        char_count[char] += 1
    else:
        char_count[char] = 1

print("字符统计：")
for char, count in char_count.items():
    print(f"'{char}': {count}次")
```

## 小结
- 字典使用花括号 `{}` 创建，存储键值对
- 使用键来访问值：`dict[key]` 或 `dict.get(key)`
- 可以添加、修改、删除键值对
- 使用 `in` 检查键是否存在
- `keys()`、`values()`、`items()` 获取字典信息
- 可以遍历键、值或键值对
- 键必须唯一且不可变

---
**上一课**: [第13课 - 元组](./第13课_元组.md)  
**下一课**: [第15课 - 字典操作](./第15课_字典操作.md)
