# 第13课：元组

## 学习目标
- 理解元组的概念和特点
- 掌握元组的创建和使用
- 了解元组与列表的区别

## 课程内容

### 什么是元组？
元组（tuple）类似列表，但是**不可修改**（不可变）。

```python
# 创建元组 - 使用圆括号
fruits = ("苹果", "香蕉", "橙子")
numbers = (1, 2, 3, 4, 5)
mixed = ("张三", 18, 1.75, True)

print(fruits)   # ('苹果', '香蕉', '橙子')
print(numbers)  # (1, 2, 3, 4, 5)
```

### 创建元组的方法

```python
# 方法1：使用圆括号
tuple1 = (1, 2, 3)

# 方法2：不使用括号（也可以）
tuple2 = 1, 2, 3

# 方法3：单个元素的元组（注意逗号）
tuple3 = (5,)  # 正确
not_tuple = (5)  # 这是整数，不是元组

# 方法4：空元组
tuple4 = ()

# 方法5：使用tuple()函数
tuple5 = tuple([1, 2, 3])
tuple6 = tuple("Python")
print(tuple6)  # ('P', 'y', 't', 'h', 'o', 'n')
```

### 访问元组元素

```python
fruits = ("苹果", "香蕉", "橙子", "葡萄")

# 使用索引
print(fruits[0])   # 苹果
print(fruits[-1])  # 葡萄

# 切片
print(fruits[1:3])  # ('香蕉', '橙子')
print(fruits[:2])   # ('苹果', '香蕉')
```

### 元组的不可变性

```python
fruits = ("苹果", "香蕉", "橙子")

# 不能修改元素
# fruits[0] = "草莓"  # 错误！会报错

# 不能添加元素
# fruits.append("葡萄")  # 错误！元组没有append方法

# 不能删除元素
# del fruits[0]  # 错误！不能删除元组中的元素
```

### 元组的基本操作

```python
# 拼接
tuple1 = (1, 2, 3)
tuple2 = (4, 5, 6)
result = tuple1 + tuple2
print(result)  # (1, 2, 3, 4, 5, 6)

# 重复
tuple3 = (0,) * 5
print(tuple3)  # (0, 0, 0, 0, 0)

# 长度
print(len(tuple1))  # 3

# 检查元素
print(2 in tuple1)  # True
print(10 in tuple1)  # False
```

### 元组的方法

元组只有两个方法：

```python
numbers = (1, 2, 3, 2, 4, 2, 5)

# count() - 统计元素出现次数
count = numbers.count(2)
print(count)  # 3

# index() - 查找元素位置
position = numbers.index(3)
print(position)  # 2
```

### 遍历元组

```python
fruits = ("苹果", "香蕉", "橙子")

# 方法1：直接遍历
for fruit in fruits:
    print(fruit)

# 方法2：使用索引
for i in range(len(fruits)):
    print(f"{i}: {fruits[i]}")

# 方法3：使用enumerate
for index, fruit in enumerate(fruits):
    print(f"{index}: {fruit}")
```

### 元组解包

```python
# 基本解包
point = (3, 5)
x, y = point
print(f"x={x}, y={y}")  # x=3, y=5

# 多个值
person = ("张三", 25, "北京")
name, age, city = person
print(f"{name}, {age}岁, 来自{city}")

# 交换变量
a = 10
b = 20
a, b = b, a
print(f"a={a}, b={b}")  # a=20, b=10
```

### 元组 vs 列表

| 特性 | 列表 | 元组 |
|------|------|------|
| 符号 | `[]` | `()` |
| 可变性 | 可变 | 不可变 |
| 速度 | 较慢 | 较快 |
| 方法 | 多 | 少 |
| 用途 | 数据会改变 | 数据不会改变 |

```python
# 列表 - 可变
my_list = [1, 2, 3]
my_list[0] = 10  # 可以修改
print(my_list)   # [10, 2, 3]

# 元组 - 不可变
my_tuple = (1, 2, 3)
# my_tuple[0] = 10  # 错误！不能修改
```

### 实用示例

#### 示例1：坐标点
```python
# 表示二维坐标
point1 = (3, 5)
point2 = (7, 9)

x1, y1 = point1
x2, y2 = point2

# 计算距离
distance = ((x2-x1)**2 + (y2-y1)**2)**0.5
print(f"两点距离：{distance:.2f}")
```

#### 示例2：RGB颜色
```python
# 使用元组表示颜色
red = (255, 0, 0)
green = (0, 255, 0)
blue = (0, 0, 255)

r, g, b = red
print(f"红色的RGB值：R={r}, G={g}, B={b}")
```

#### 示例3：函数返回多个值
```python
def get_student_info():
    name = "张三"
    age = 18
    score = 95
    return name, age, score  # 返回元组

# 接收返回值
student_name, student_age, student_score = get_student_info()
print(f"{student_name}, {student_age}岁, 成绩{student_score}分")
```

#### 示例4：日期表示
```python
# 使用元组表示日期
today = (2024, 12, 25)
year, month, day = today

print(f"今天是{year}年{month}月{day}日")

# 多个日期
dates = [
    (2024, 1, 1),
    (2024, 5, 1),
    (2024, 10, 1)
]

for date in dates:
    year, month, day = date
    print(f"{year}-{month:02d}-{day:02d}")
```

## 练习题

### 练习1：学生信息
创建一个元组存储学生信息（姓名、年龄、成绩），然后：
- 打印所有信息
- 使用解包获取各个字段
- 尝试修改年龄（观察错误）

### 练习2：坐标计算
创建两个坐标点的元组，计算：
- 两点的中点坐标
- 两点之间的距离

### 练习3：成绩统计
创建一个包含多个学生成绩元组的列表：
```python
students = [
    ("张三", 85),
    ("李四", 92),
    ("王五", 78)
]
```
计算平均分并找出最高分的学生。

### 参考答案
```python
# 练习1：学生信息
print("=== 练习1：学生信息 ===")
student = ("张三", 18, 95)

# 打印所有信息
print("学生信息：", student)

# 解包
name, age, score = student
print(f"姓名：{name}")
print(f"年龄：{age}")
print(f"成绩：{score}")

# 尝试修改（会报错）
try:
    student[1] = 19
except TypeError as e:
    print(f"错误：{e}")
    print("元组不可修改！")

# 练习2：坐标计算
print("\n=== 练习2：坐标计算 ===")
point1 = (2, 3)
point2 = (8, 7)

x1, y1 = point1
x2, y2 = point2

# 中点
mid_x = (x1 + x2) / 2
mid_y = (y1 + y2) / 2
midpoint = (mid_x, mid_y)
print(f"中点坐标：{midpoint}")

# 距离
distance = ((x2-x1)**2 + (y2-y1)**2)**0.5
print(f"两点距离：{distance:.2f}")

# 练习3：成绩统计
print("\n=== 练习3：成绩统计 ===")
students = [
    ("张三", 85),
    ("李四", 92),
    ("王五", 78),
    ("赵六", 88),
    ("钱七", 95)
]

# 计算平均分
total = 0
for name, score in students:
    total += score
average = total / len(students)
print(f"平均分：{average:.2f}")

# 找最高分
max_score = 0
top_student = ""

for name, score in students:
    if score > max_score:
        max_score = score
        top_student = name

print(f"最高分：{top_student} - {max_score}分")

# 显示所有学生
print("\n所有学生成绩：")
for i, (name, score) in enumerate(students, 1):
    print(f"{i}. {name}: {score}分")
```

## 小结
- 元组使用圆括号 `()` 创建
- 元组是不可变的，创建后不能修改
- 元组比列表更快，占用内存更少
- 元组只有 `count()` 和 `index()` 两个方法
- 元组可以解包，方便获取多个值
- 适合存储不需要修改的数据
- 函数可以返回元组来返回多个值

---
**上一课**: [第12课 - 列表操作](./第12课_列表操作.md)  
**下一课**: [第14课 - 字典基础](./第14课_字典基础.md)
