# 第12课：列表操作

## 学习目标
- 掌握列表的增删改查操作
- 学会使用列表的常用方法
- 理解列表的排序和反转

## 课程内容

### 添加元素

#### append() - 在末尾添加
```python
fruits = ["苹果", "香蕉"]
fruits.append("橙子")
print(fruits)  # ['苹果', '香蕉', '橙子']
```

#### insert() - 在指定位置插入
```python
fruits = ["苹果", "橙子"]
fruits.insert(1, "香蕉")  # 在索引1的位置插入
print(fruits)  # ['苹果', '香蕉', '橙子']
```

#### extend() - 添加多个元素
```python
fruits = ["苹果", "香蕉"]
more_fruits = ["橙子", "葡萄"]
fruits.extend(more_fruits)
print(fruits)  # ['苹果', '香蕉', '橙子', '葡萄']
```

### 删除元素

#### remove() - 删除指定值
```python
fruits = ["苹果", "香蕉", "橙子"]
fruits.remove("香蕉")
print(fruits)  # ['苹果', '橙子']
```

#### pop() - 删除指定位置（默认最后一个）
```python
fruits = ["苹果", "香蕉", "橙子"]

# 删除最后一个
last = fruits.pop()
print(last)    # 橙子
print(fruits)  # ['苹果', '香蕉']

# 删除指定位置
first = fruits.pop(0)
print(first)   # 苹果
print(fruits)  # ['香蕉']
```

#### del - 删除指定位置或整个列表
```python
fruits = ["苹果", "香蕉", "橙子", "葡萄"]

# 删除指定位置
del fruits[1]
print(fruits)  # ['苹果', '橙子', '葡萄']

# 删除切片
del fruits[1:3]
print(fruits)  # ['苹果']
```

#### clear() - 清空列表
```python
fruits = ["苹果", "香蕉", "橙子"]
fruits.clear()
print(fruits)  # []
```

### 查找和统计

#### index() - 查找元素位置
```python
fruits = ["苹果", "香蕉", "橙子", "香蕉"]
position = fruits.index("香蕉")
print(position)  # 1 (第一次出现的位置)
```

#### count() - 统计元素出现次数
```python
numbers = [1, 2, 3, 2, 4, 2, 5]
count = numbers.count(2)
print(count)  # 3
```

### 排序和反转

#### sort() - 排序（会修改原列表）
```python
numbers = [3, 1, 4, 1, 5, 9, 2]
numbers.sort()
print(numbers)  # [1, 1, 2, 3, 4, 5, 9]

# 降序排序
numbers.sort(reverse=True)
print(numbers)  # [9, 5, 4, 3, 2, 1, 1]
```

#### sorted() - 排序（返回新列表）
```python
numbers = [3, 1, 4, 1, 5]
sorted_numbers = sorted(numbers)
print(numbers)         # [3, 1, 4, 1, 5] (原列表不变)
print(sorted_numbers)  # [1, 1, 3, 4, 5] (新列表)
```

#### reverse() - 反转列表
```python
fruits = ["苹果", "香蕉", "橙子"]
fruits.reverse()
print(fruits)  # ['橙子', '香蕉', '苹果']
```

### 复制列表

```python
# 方法1：使用copy()
list1 = [1, 2, 3]
list2 = list1.copy()

# 方法2：使用切片
list3 = list1[:]

# 方法3：使用list()
list4 = list(list1)

# 注意：直接赋值不是复制
list5 = list1  # list5和list1指向同一个列表
```

### 实用示例

#### 示例1：待办事项管理
```python
todo_list = []

# 添加任务
todo_list.append("写作业")
todo_list.append("看书")
todo_list.append("运动")

print("=== 待办事项 ===")
for i, task in enumerate(todo_list, 1):
    print(f"{i}. {task}")

# 完成任务（删除）
todo_list.remove("看书")
print("\n完成'看书'后的列表：")
for i, task in enumerate(todo_list, 1):
    print(f"{i}. {task}")
```

#### 示例2：成绩管理系统
```python
scores = []

# 输入成绩
print("请输入5个学生的成绩：")
for i in range(5):
    score = float(input(f"第{i+1}个学生："))
    scores.append(score)

# 分析
print(f"\n原始成绩：{scores}")
print(f"最高分：{max(scores)}")
print(f"最低分：{min(scores)}")
print(f"平均分：{sum(scores)/len(scores):.2f}")

# 排序
scores.sort(reverse=True)
print(f"从高到低：{scores}")
```

#### 示例3：购物车
```python
cart = []

while True:
    print("\n=== 购物车 ===")
    print("1. 添加商品")
    print("2. 删除商品")
    print("3. 查看购物车")
    print("4. 结算")
    
    choice = input("请选择：")
    
    if choice == "1":
        item = input("输入商品名称：")
        cart.append(item)
        print(f"已添加：{item}")
    
    elif choice == "2":
        if cart:
            print("当前商品：", cart)
            item = input("输入要删除的商品：")
            if item in cart:
                cart.remove(item)
                print(f"已删除：{item}")
            else:
                print("商品不存在")
        else:
            print("购物车是空的")
    
    elif choice == "3":
        if cart:
            print("\n购物车商品：")
            for i, item in enumerate(cart, 1):
                print(f"{i}. {item}")
        else:
            print("购物车是空的")
    
    elif choice == "4":
        print(f"\n共{len(cart)}件商品")
        print("感谢购买！")
        break
```

### 列表推导式（简介）
快速创建列表的方法：

```python
# 创建1到10的平方
squares = [x**2 for x in range(1, 11)]
print(squares)  # [1, 4, 9, 16, 25, 36, 49, 64, 81, 100]

# 筛选偶数
numbers = [1, 2, 3, 4, 5, 6, 7, 8, 9, 10]
evens = [x for x in numbers if x % 2 == 0]
print(evens)  # [2, 4, 6, 8, 10]
```

## 练习题

### 练习1：学生名单管理
创建一个学生名单程序：
- 添加学生
- 删除学生
- 查看所有学生
- 查找学生是否存在

### 练习2：数字处理
给定列表 [34, 12, 78, 45, 23, 67, 89, 12, 34]：
- 删除所有重复的数字
- 按从小到大排序
- 输出结果

### 练习3：成绩排名
输入5个学生的姓名和成绩，按成绩从高到低排序并显示排名。

### 参考答案
```python
# 练习1：学生名单管理
students = []

while True:
    print("\n=== 学生名单管理 ===")
    print("1. 添加学生")
    print("2. 删除学生")
    print("3. 查看所有学生")
    print("4. 查找学生")
    print("5. 退出")
    
    choice = input("请选择：")
    
    if choice == "1":
        name = input("输入学生姓名：")
        students.append(name)
        print(f"已添加：{name}")
    
    elif choice == "2":
        if students:
            name = input("输入要删除的学生：")
            if name in students:
                students.remove(name)
                print(f"已删除：{name}")
            else:
                print("学生不存在")
        else:
            print("名单是空的")
    
    elif choice == "3":
        if students:
            print(f"\n共{len(students)}个学生：")
            for i, name in enumerate(students, 1):
                print(f"{i}. {name}")
        else:
            print("名单是空的")
    
    elif choice == "4":
        name = input("输入要查找的学生：")
        if name in students:
            index = students.index(name)
            print(f"{name}在名单中，位置：{index+1}")
        else:
            print(f"{name}不在名单中")
    
    elif choice == "5":
        print("再见！")
        break

# 练习2：数字处理
numbers = [34, 12, 78, 45, 23, 67, 89, 12, 34]
print("\n=== 数字处理 ===")
print("原始列表：", numbers)

# 删除重复
unique_numbers = []
for num in numbers:
    if num not in unique_numbers:
        unique_numbers.append(num)

# 排序
unique_numbers.sort()
print("去重并排序：", unique_numbers)

# 练习3：成绩排名
print("\n=== 成绩排名 ===")
students_scores = []

for i in range(5):
    name = input(f"第{i+1}个学生姓名：")
    score = float(input(f"{name}的成绩："))
    students_scores.append([name, score])

# 按成绩排序（从高到低）
students_scores.sort(key=lambda x: x[1], reverse=True)

print("\n=== 排名结果 ===")
for i, (name, score) in enumerate(students_scores, 1):
    print(f"第{i}名：{name} - {score}分")
```

## 小结
- `append()` 在末尾添加元素
- `insert()` 在指定位置插入元素
- `remove()` 删除指定值
- `pop()` 删除并返回指定位置的元素
- `sort()` 排序列表
- `reverse()` 反转列表
- `index()` 查找元素位置
- `count()` 统计元素出现次数

---
**上一课**: [第11课 - 列表基础](./第11课_列表基础.md)  
**下一课**: [第13课 - 元组](./第13课_元组.md)
