# 第11课：列表基础

## 学习目标
- 理解什么是列表
- 学会创建和访问列表
- 掌握列表的基本特性

## 课程内容

### 什么是列表？
列表是Python中最常用的数据结构，可以存储多个值。

```python
# 创建列表
fruits = ["苹果", "香蕉", "橙子"]
numbers = [1, 2, 3, 4, 5]
mixed = ["张三", 18, 1.75, True]  # 可以混合类型

print(fruits)   # ['苹果', '香蕉', '橙子']
print(numbers)  # [1, 2, 3, 4, 5]
```

### 创建列表的方法

```python
# 方法1：使用方括号
list1 = [1, 2, 3]

# 方法2：空列表
list2 = []

# 方法3：使用list()函数
list3 = list("Python")
print(list3)  # ['P', 'y', 't', 'h', 'o', 'n']
```

### 访问列表元素

```python
fruits = ["苹果", "香蕉", "橙子", "葡萄", "西瓜"]

# 使用索引访问（从0开始）
print(fruits[0])   # 苹果（第一个）
print(fruits[1])   # 香蕉（第二个）
print(fruits[-1])  # 西瓜（最后一个）
print(fruits[-2])  # 葡萄（倒数第二个）
```

### 列表切片

```python
numbers = [0, 1, 2, 3, 4, 5, 6, 7, 8, 9]

print(numbers[2:5])    # [2, 3, 4] (索引2到4)
print(numbers[:5])     # [0, 1, 2, 3, 4] (开始到索引4)
print(numbers[5:])     # [5, 6, 7, 8, 9] (索引5到结束)
print(numbers[::2])    # [0, 2, 4, 6, 8] (每隔一个)
print(numbers[::-1])   # [9, 8, 7, 6, 5, 4, 3, 2, 1, 0] (反转)
```

### 列表长度

```python
fruits = ["苹果", "香蕉", "橙子"]
length = len(fruits)
print(f"列表长度：{length}")  # 3
```

### 修改列表元素

```python
fruits = ["苹果", "香蕉", "橙子"]
print("修改前：", fruits)

# 修改单个元素
fruits[1] = "草莓"
print("修改后：", fruits)  # ['苹果', '草莓', '橙子']
```

### 检查元素是否存在

```python
fruits = ["苹果", "香蕉", "橙子"]

# 使用 in 运算符
if "苹果" in fruits:
    print("苹果在列表中")

if "西瓜" not in fruits:
    print("西瓜不在列表中")
```

### 遍历列表

```python
fruits = ["苹果", "香蕉", "橙子", "葡萄"]

# 方法1：直接遍历
for fruit in fruits:
    print(fruit)

# 方法2：使用索引
for i in range(len(fruits)):
    print(f"{i+1}. {fruits[i]}")

# 方法3：同时获取索引和值
for index, fruit in enumerate(fruits):
    print(f"{index}: {fruit}")
```

### 实用示例

#### 示例1：购物清单
```python
shopping_list = ["牛奶", "面包", "鸡蛋", "苹果"]

print("=== 购物清单 ===")
for i, item in enumerate(shopping_list, 1):
    print(f"{i}. {item}")
```

#### 示例2：成绩管理
```python
scores = [85, 92, 78, 95, 88]

print(f"共有{len(scores)}个成绩")
print(f"第一个成绩：{scores[0]}")
print(f"最后一个成绩：{scores[-1]}")
print(f"前三个成绩：{scores[:3]}")
```

#### 示例3：查找元素
```python
numbers = [10, 23, 45, 67, 89, 34, 12]
target = 67

if target in numbers:
    index = numbers.index(target)
    print(f"{target}在列表中，位置是{index}")
else:
    print(f"{target}不在列表中")
```

### 列表的基本操作

```python
# 拼接列表
list1 = [1, 2, 3]
list2 = [4, 5, 6]
result = list1 + list2
print(result)  # [1, 2, 3, 4, 5, 6]

# 重复列表
list3 = [0] * 5
print(list3)  # [0, 0, 0, 0, 0]

# 比较列表
print([1, 2, 3] == [1, 2, 3])  # True
print([1, 2, 3] == [3, 2, 1])  # False
```

## 练习题

### 练习1：创建学生信息列表
创建一个列表存储5个学生的姓名，然后：
- 打印第一个和最后一个学生的姓名
- 打印列表长度
- 检查"张三"是否在列表中

### 练习2：温度记录
创建一个列表存储一周的温度（7个数字），然后：
- 打印前三天的温度
- 打印后三天的温度
- 打印所有温度（使用循环）

### 练习3：成绩分析
给定成绩列表 [78, 92, 85, 67, 95, 88, 73]：
- 找出最高分和最低分
- 计算平均分
- 统计及格（>=60）的人数

### 参考答案
```python
# 练习1：创建学生信息列表
students = ["张三", "李四", "王五", "赵六", "钱七"]

print("第一个学生：", students[0])
print("最后一个学生：", students[-1])
print("学生人数：", len(students))

if "张三" in students:
    print("张三在列表中")
else:
    print("张三不在列表中")

# 练习2：温度记录
temperatures = [22, 24, 26, 25, 23, 21, 20]

print("\n=== 温度记录 ===")
print("前三天温度：", temperatures[:3])
print("后三天温度：", temperatures[-3:])

print("\n一周温度：")
days = ["周一", "周二", "周三", "周四", "周五", "周六", "周日"]
for i in range(len(temperatures)):
    print(f"{days[i]}: {temperatures[i]}°C")

# 练习3：成绩分析
scores = [78, 92, 85, 67, 95, 88, 73]

print("\n=== 成绩分析 ===")

# 最高分和最低分
max_score = scores[0]
min_score = scores[0]

for score in scores:
    if score > max_score:
        max_score = score
    if score < min_score:
        min_score = score

print(f"最高分：{max_score}")
print(f"最低分：{min_score}")

# 平均分
total = 0
for score in scores:
    total += score
average = total / len(scores)
print(f"平均分：{average:.2f}")

# 及格人数
pass_count = 0
for score in scores:
    if score >= 60:
        pass_count += 1

print(f"及格人数：{pass_count}/{len(scores)}")
print(f"及格率：{pass_count/len(scores)*100:.1f}%")
```

## 小结
- 列表用方括号 `[]` 创建，可以存储多个值
- 索引从0开始，负数索引从末尾开始
- 使用切片可以获取列表的一部分
- `len()` 获取列表长度
- `in` 和 `not in` 检查元素是否存在
- 列表是可变的，可以修改元素
- 可以使用 for 循环遍历列表

---
**上一课**: [第10课 - break和continue](./第10课_break和continue.md)  
**下一课**: [第12课 - 列表操作](./第12课_列表操作.md)
