# 第10课：break和continue

## 学习目标
- 掌握 break 语句的使用
- 学会使用 continue 语句
- 理解循环控制的技巧

## 课程内容

### break 语句
`break` 用于立即退出循环。

```python
# 找到第一个偶数就停止
for i in range(1, 11):
    if i % 2 == 0:
        print(f"找到第一个偶数：{i}")
        break
    print(f"{i}是奇数")

# 输出：
# 1是奇数
# 找到第一个偶数：2
```

### continue 语句
`continue` 跳过本次循环，继续下一次循环。

```python
# 只打印奇数
for i in range(1, 11):
    if i % 2 == 0:
        continue  # 跳过偶数
    print(i)

# 输出：1 3 5 7 9
```

### break vs continue

```python
print("=== break 示例 ===")
for i in range(1, 6):
    if i == 3:
        break  # 遇到3就停止
    print(i)
# 输出：1 2

print("\n=== continue 示例 ===")
for i in range(1, 6):
    if i == 3:
        continue  # 跳过3
    print(i)
# 输出：1 2 4 5
```

### 实用示例

#### 示例1：查找元素
```python
numbers = [10, 23, 45, 67, 89, 34]
target = 67
found = False

for num in numbers:
    if num == target:
        print(f"找到了！{target}在列表中")
        found = True
        break

if not found:
    print(f"{target}不在列表中")
```

#### 示例2：密码验证（限制次数）
```python
password = "123456"
max_attempts = 3

for attempt in range(1, max_attempts + 1):
    user_input = input(f"请输入密码（第{attempt}次）：")
    
    if user_input == password:
        print("登录成功！")
        break
    else:
        remaining = max_attempts - attempt
        if remaining > 0:
            print(f"密码错误！还有{remaining}次机会")
        else:
            print("密码错误！账户已锁定")
```

#### 示例3：跳过特定值
```python
# 打印1到10，但跳过5的倍数
for i in range(1, 11):
    if i % 5 == 0:
        continue
    print(i, end=" ")

# 输出：1 2 3 4 6 7 8 9
```

### 在 while 循环中使用

#### break 在 while 中
```python
count = 0
while True:
    count += 1
    print(count)
    
    if count >= 5:
        break  # 达到5就退出

# 输出：1 2 3 4 5
```

#### continue 在 while 中
```python
count = 0
while count < 10:
    count += 1
    
    if count % 2 == 0:
        continue  # 跳过偶数
    
    print(count)

# 输出：1 3 5 7 9
```

### 嵌套循环中的 break

```python
# 在嵌套循环中，break只退出当前循环
for i in range(1, 4):
    print(f"外层循环：{i}")
    for j in range(1, 4):
        if j == 2:
            break  # 只退出内层循环
        print(f"  内层循环：{j}")
    print()

# 输出：
# 外层循环：1
#   内层循环：1
#
# 外层循环：2
#   内层循环：1
#
# 外层循环：3
#   内层循环：1
```

### 实战应用

#### 应用1：菜单系统
```python
while True:
    print("\n=== 主菜单 ===")
    print("1. 开始游戏")
    print("2. 查看设置")
    print("3. 退出")
    
    choice = input("请选择：")
    
    if choice == "1":
        print("游戏开始...")
    elif choice == "2":
        print("设置界面...")
    elif choice == "3":
        print("再见！")
        break
    else:
        print("无效选择！")
        continue
```

#### 应用2：输入验证
```python
# 只接受正数
while True:
    num = input("请输入一个正数（输入q退出）：")
    
    if num.lower() == 'q':
        print("退出程序")
        break
    
    try:
        num = float(num)
        if num <= 0:
            print("必须是正数！")
            continue
        print(f"你输入的数是：{num}")
        break
    except:
        print("输入无效！")
        continue
```

#### 应用3：质数判断
```python
num = int(input("请输入一个大于1的整数："))

if num < 2:
    print("请输入大于1的数")
else:
    is_prime = True
    for i in range(2, num):
        if num % i == 0:
            print(f"{num}不是质数，因为可以被{i}整除")
            is_prime = False
            break
    
    if is_prime:
        print(f"{num}是质数")
```

## 练习题

### 练习1：猜数字游戏
程序随机生成1-100的数字，用户猜测：
- 猜对了：显示"恭喜"并退出
- 猜错了：提示"太大"或"太小"
- 限制10次机会

### 练习2：成绩统计
输入多个学生成绩（输入-1结束）：
- 跳过不合法的成绩（<0或>100）
- 计算平均分
- 统计及格人数

### 练习3：打印特殊图案
打印1到50的数字，但：
- 跳过3的倍数
- 遇到40就停止

### 参考答案
```python
# 练习1：猜数字游戏
import random

print("=== 猜数字游戏 ===")
secret = random.randint(1, 100)
max_attempts = 10

for attempt in range(1, max_attempts + 1):
    guess = int(input(f"第{attempt}次猜测（1-100）："))
    
    if guess == secret:
        print(f"恭喜你猜对了！答案是{secret}")
        break
    elif guess < secret:
        print("太小了！")
    else:
        print("太大了！")
    
    if attempt == max_attempts:
        print(f"机会用完了！答案是{secret}")

# 练习2：成绩统计
print("\n=== 成绩统计 ===")
total = 0
count = 0
pass_count = 0

print("请输入成绩（输入-1结束）")

while True:
    score = float(input("成绩："))
    
    if score == -1:
        break
    
    # 跳过不合法成绩
    if score < 0 or score > 100:
        print("成绩无效，请输入0-100之间的数")
        continue
    
    total += score
    count += 1
    
    if score >= 60:
        pass_count += 1

if count > 0:
    average = total / count
    print(f"\n共{count}个学生")
    print(f"平均分：{average:.2f}")
    print(f"及格人数：{pass_count}")
    print(f"及格率：{pass_count/count*100:.1f}%")
else:
    print("没有输入任何成绩")

# 练习3：打印特殊图案
print("\n=== 打印特殊数字 ===")
for i in range(1, 51):
    if i >= 40:
        break
    
    if i % 3 == 0:
        continue
    
    print(i, end=" ")

print()  # 换行
```

## 小结
- `break` 立即退出整个循环
- `continue` 跳过本次循环，继续下一次
- `break` 常用于找到目标后退出
- `continue` 常用于跳过特定条件
- 在嵌套循环中，break/continue 只影响当前层循环
- 合理使用可以让代码更简洁高效

---
**上一课**: [第9课 - for循环](./第9课_for循环.md)  
**下一课**: [第11课 - 列表基础](./第11课_列表基础.md)
