# 第17课：函数参数 - 习题

---

## 📚 知识点详解

### 一、可变参数 (*args)

**定义：** 可变参数允许函数接收任意数量的位置参数,这些参数会被打包成一个元组(tuple)。

**语法：** 在参数名前加一个星号 `*`

**特点：**
- 参数名通常使用 `*args` (arguments的缩写),但可以是任何名称
- 函数内部,`args` 是一个元组类型
- 可以传入0个、1个或多个参数
- 必须在普通位置参数之后

**示例：**
```python
def print_numbers(*numbers):
    print(f"参数类型: {type(numbers)}")  # <class 'tuple'>
    print(f"参数内容: {numbers}")
    for num in numbers:
        print(num)

# 调用方式
print_numbers(1, 2, 3)        # 传入3个参数
print_numbers(10)             # 传入1个参数
print_numbers()               # 不传参数也可以
```

**实际应用场景：**
- 数学计算函数(求和、求平均值等)
- 日志记录函数
- 数据处理函数

---

### 二、可变关键字参数 (**kwargs)

**定义：** 可变关键字参数允许函数接收任意数量的关键字参数,这些参数会被打包成一个字典(dict)。

**语法：** 在参数名前加两个星号 `**`

**特点：**
- 参数名通常使用 `**kwargs` (keyword arguments的缩写),但可以是任何名称
- 函数内部,`kwargs` 是一个字典类型
- 键(key)是参数名,值(value)是参数值
- 可以传入0个或多个关键字参数
- 必须在所有其他参数之后

**示例：**
```python
def create_user(**user_info):
    print(f"参数类型: {type(user_info)}")  # <class 'dict'>
    print(f"参数内容: {user_info}")
    
    for key, value in user_info.items():
        print(f"{key} = {value}")

# 调用方式
create_user(name="李四", age=30, city="北京", job="工程师")
create_user(name="王五")  # 只传一个参数
create_user()             # 不传参数也可以
```

**实际应用场景：**
- 配置函数(接收各种配置选项)
- 数据库查询函数(接收各种查询条件)
- API请求函数(接收各种请求参数)

---

### 三、混合参数

**定义：** 在一个函数中同时使用多种类型的参数,包括普通参数、默认参数、可变参数和可变关键字参数。

**参数顺序规则(非常重要!)：**
```python
def function(普通参数, *args, 默认参数=值, **kwargs):
    pass
```

**顺序必须是：**
1. 普通位置参数
2. 可变参数 `*args`
3. 默认参数
4. 可变关键字参数 `**kwargs`

**示例：**
```python
def order_meal(customer, *dishes, drink="可乐", **extras):
    """
    customer: 普通参数(必需)
    *dishes: 可变参数(点的菜品)
    drink: 默认参数(饮料,默认可乐)
    **extras: 可变关键字参数(其他要求)
    """
    print(f"顾客: {customer}")
    
    if dishes:
        print(f"菜品: {', '.join(dishes)}")
    
    print(f"饮料: {drink}")
    
    if extras:
        print("其他要求:")
        for key, value in extras.items():
            print(f"  {key}: {value}")

# 各种调用方式
order_meal("张三", "宫保鸡丁", "鱼香肉丝")
order_meal("李四", "麻婆豆腐", drink="橙汁")
order_meal("王五", "回锅肉", "青椒肉丝", drink="雪碧", 辣度="微辣", 备注="少油")
```

**混合参数的调用规则：**
```python
def mixed_func(a, b, *args, c=10, d=20, **kwargs):
    pass

# 正确调用
mixed_func(1, 2)                           # a=1, b=2
mixed_func(1, 2, 3, 4)                     # a=1, b=2, args=(3,4)
mixed_func(1, 2, c=30)                     # a=1, b=2, c=30
mixed_func(1, 2, 3, c=30, d=40)           # a=1, b=2, args=(3,), c=30, d=40
mixed_func(1, 2, 3, 4, c=30, x=100, y=200) # a=1, b=2, args=(3,4), c=30, kwargs={'x':100,'y':200}
```

**实际应用场景：**
- 装饰器函数
- 框架和库的API设计
- 需要高度灵活性的函数

---

### 四、参数解包

**列表/元组解包 (`*`)：**
```python
def add(a, b, c):
    return a + b + c

numbers = [1, 2, 3]
result = add(*numbers)  # 相当于 add(1, 2, 3)
```

**字典解包 (`**`)：**
```python
def greet(name, age, city):
    print(f"{name}, {age}岁, 来自{city}")

person = {"name": "赵六", "age": 28, "city": "深圳"}
greet(**person)  # 相当于 greet(name="赵六", age=28, city="深圳")
```

---

### 五、常见错误和注意事项

**❌ 错误1：参数顺序错误**
```python
# 错误：**kwargs 必须在最后
def wrong(a, **kwargs, *args):  # SyntaxError
    pass
```

**❌ 错误2：可变参数后的普通参数必须用关键字传递**
```python
def func(a, *args, b):
    pass

func(1, 2, 3)  # 错误！b没有值
func(1, 2, b=3)  # 正确
```

**✅ 最佳实践：**
- 参数不要太多,保持函数简洁
- 给参数起有意义的名字
- 在函数文档中说明参数用途
- 合理使用默认参数减少调用复杂度

---

## 习题1：默认参数
定义一个函数 `greet(name, greeting="你好")`，使用默认参数实现问候功能。

## 习题2：多个默认参数
定义一个函数 `create_profile(name, age=18, city="北京")`，创建用户档案。

## 习题3：关键字参数
定义一个函数 `order_food(main, drink, dessert)`，使用关键字参数调用它。

## 习题4：可变参数
定义一个函数 `sum_all(*numbers)`，接收任意数量的参数并返回它们的和。

```python
def sum_all(*numbers):
    total = 0
    for num in numbers:
        total += num
    return total

# 测试
print(sum_all(1, 2, 3))  # 输出: 6
print(sum_all(10, 20, 30, 40))  # 输出: 100
```

## 习题5：可变关键字参数
定义一个函数 `print_info(**kwargs)`，接收任意数量的关键字参数并打印。

```python
def print_info(**kwargs):
    for key, value in kwargs.items():
        print(f"{key}: {value}")

# 测试
print_info(姓名="张三", 年龄=25, 城市="上海")
# 输出:
# 姓名: 张三
# 年龄: 25
# 城市: 上海
```

## 习题6：混合参数
定义一个函数 `make_pizza(size, *toppings, **details)`，接收必需参数、可变参数和关键字参数。

```python
def make_pizza(size, *toppings, **details):
    print(f"制作一个 {size} 寸的披萨")
    
    if toppings:
        print("配料:")
        for topping in toppings:
            print(f"  - {topping}")
    
    if details:
        print("其他信息:")
        for key, value in details.items():
            print(f"  {key}: {value}")

# 测试
make_pizza(12, "培根", "蘑菇", "洋葱", 厚度="厚底", 辣度="中辣")
# 输出:
# 制作一个 12 寸的披萨
# 配料:
#   - 培根
#   - 蘑菇
#   - 洋葱
# 其他信息:
#   厚度: 厚底
#   辣度: 中辣
```

## 习题7：参数解包
创建列表 `numbers = [1, 2, 3]`，使用 `*` 解包传递给函数。

## 习题8：字典解包
创建字典 `person = {"name": "张三", "age": 25}`，使用 `**` 解包传递给函数。

## 习题9：计算平均分
定义一个函数 `calculate_average(*scores)`，计算任意数量成绩的平均分。

## 习题10：构建URL
定义一个函数 `build_url(base, **params)`，根据基础URL和参数构建完整URL。
例如：`build_url("https://api.com", user="admin", page=1)` 
返回：`"https://api.com?user=admin&page=1"`
